#!/bin/sh

echo start create ftp user

DIR=`dirname "${0}"`

USER=$1
PASS=$2

ROOTFS_RO=`"${DIR}/check_rootfs_ro.sh"`

# rootfs read write
if [ ${ROOTFS_RO} == "ro" ];then
  mount -o rw,remount /
fi

rm /etc/vsftpd/users.lst
rm /etc/vsftpd/vsftpd-virtual-user.db

echo $USER > /etc/vsftpd/users.lst
echo $PASS >> /etc/vsftpd/users.lst

db_load -T -t hash -f /etc/vsftpd/users.lst /etc/vsftpd/vsftpd-virtual-user.db

# rootfs read only
if [ ${ROOTFS_RO} == "ro" ];then
  mount -o ro,remount /
fi

/etc/init.d/vsftpd restart

echo finish create ftp user

# success
exit 0
